/* TROIA distributor
 * version 0.3 date 2004-09-01
 * Copyright (C) 2003-2004 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
     
#include "tools.h"
#include "config.h"
#include "td_config.h"

//parsed settings from troia_dist configuration file
int td_verbose;
in_addr_t td_in_listen_addr;
in_port_t td_in_listen_port;
in_addr_t td_out_bind_addr;
in_port_t td_out_bind_port;
in_addr_t td_out_ip_base, td_out_ip_step;
in_port_t td_out_dest_port;
unsigned short td_out_dev_cnt, td_out_ser_cnt, td_out_pix_cnt;
char td_out_file[256];
char td_fmt_file[256];

//buffers used to parse settings
char td_verbose_str[8];
char td_in_listen_str[32];
char td_out_bind_str[32];
char td_out_ip_base_str[16], td_out_ip_step_str[16], td_out_dest_port_str[16];
char td_out_dev_cnt_str[16], td_out_ser_cnt_str[16], td_out_pix_cnt_str[16];

//settings in troia_dist configuration file
st_config_setting td_settings[] = 
{
  { "", "verbose", td_verbose_str, sizeof( td_verbose_str ), 0 },
  { "input", "listen", td_in_listen_str, sizeof( td_in_listen_str ), 0 },
  { "output", "bind", td_out_bind_str, sizeof( td_out_bind_str ), 0 },
  { "output", "ip_base", td_out_ip_base_str, sizeof( td_out_ip_base_str ), 0 },
  { "output", "ip_step", td_out_ip_step_str, sizeof( td_out_ip_step_str ), 0 },
  { "output", "dest_port", td_out_dest_port_str, sizeof( td_out_dest_port_str ), 0 },
  { "output", "dev_cnt", td_out_dev_cnt_str, sizeof( td_out_dev_cnt_str ), 0 },
  { "output", "ser_cnt", td_out_ser_cnt_str, sizeof( td_out_ser_cnt_str ), 0 },
  { "output", "pix_cnt", td_out_pix_cnt_str, sizeof( td_out_pix_cnt_str ), 0 },
  { "format", "file", td_fmt_file, sizeof( td_fmt_file ), 0 },
};

//get troia_dist configuration from configuration file
void td_config_get( char * filename )
{
  char * p_colon, * p_addr_str, * p_port_str;
  int i, port;

  //read config file
  config_parse( filename, td_settings, count( td_settings ) );

  //get verbose flag
  td_verbose = 0;
  for( i = 0; td_verbose_str[i] != 0; i++ )
  {
    if( strchr( "+123456789yY", td_verbose_str[i] ) )
    {
      td_verbose = 1;
      break;
    }
    if( strchr( "-0nN", td_verbose_str[i] ) )
    {
      td_verbose = 0;
      break;
    }
  }

  //input

  //divide listen string into IP and port
  p_colon = strchr( td_in_listen_str, ':' );
  if( p_colon == NULL )
  {
    printf( "config: input: no port found in listen address (\"%s\"), using 2323\n", td_in_listen_str );
    p_addr_str = td_in_listen_str;
    p_port_str = "2323";
  }
  else
  {
    p_addr_str = td_in_listen_str;
    *p_colon = 0;
    p_port_str = p_colon + 1;
  }

  //parse listen IP
  td_in_listen_addr = inet_addr( p_addr_str );
  if( td_in_listen_addr == INADDR_NONE )
  {
    printf( "config: input: invalid listen IP (\"%s\"), using \"0.0.0.0\"\n", p_addr_str );
    td_in_listen_addr = INADDR_ANY;
  }

  //convert listen port into number
  if( sscanf( p_port_str, "%i", &port ) != 1 )
  {
    printf( "config: input: error in format of listen port (\"%s\"), using 2323\n", p_port_str );
    port = 2323;
  }
  if( port < 0 || port > 65535 )
  {
    printf( "config: input: invalid listen port number (%d), using 2323\n", port );
    port = 2323;
  }
  td_in_listen_port = (in_port_t)port;

  //output

  //divide bind string into IP and port
  p_colon = strchr( td_out_bind_str, ':' );
  if( p_colon == NULL )
  {
    printf( "config: output: no port found in bind address (\"%s\"), using 2342\n", td_out_bind_str );
    p_addr_str = td_out_bind_str;
    p_port_str = "2342";
  }
  else
  {
    p_addr_str = td_out_bind_str;
    *p_colon = 0;
    p_port_str = p_colon + 1;
  }

  //parse bind IP
  td_out_bind_addr = inet_addr( p_addr_str );
  if( td_out_bind_addr == INADDR_NONE )
  {
    printf( "config: output: invalid bind IP (\"%s\"), using \"0.0.0.0\"\n", p_addr_str );
    td_out_bind_addr = INADDR_ANY;
  }

  //convert bind port into number
  if( sscanf( p_port_str, "%i", &port ) != 1 )
  {
    printf( "config: output: error in format of bind port (\"%s\"), using 2342\n", p_port_str );
    port = 2342;
  }
  if( port < 0 || port > 65535 )
  {
    printf( "config: output: invalid bind port number (%d), using 2342\n", port );
    port = 2342;
  }
  td_out_bind_port = (in_port_t)port;

  //parse IP base
  td_out_ip_base = inet_addr( td_out_ip_base_str );
  if( td_out_ip_base == INADDR_NONE )
  {
    printf( "config: output: invalid IP base (\"%s\"), using \"10.23.42.0\"\n", td_out_ip_base_str );
    td_out_ip_base = (in_addr_t)htonl( 0x0A172A00 );
  }

  //parse IP step
  td_out_ip_step = inet_addr( td_out_ip_step_str );
  if( td_out_ip_step == INADDR_NONE )
  {
    printf( "config: output: invalid IP step (\"%s\"), using \"0.0.0.1\"\n", td_out_ip_step_str );
    td_out_ip_step = (in_addr_t)htonl( 0x00000001 );
  }

  //convert destination port into number
  if( sscanf( td_out_dest_port_str, "%i", &port ) != 1 )
  {
    printf( "config: output: error in format of destination port (\"%s\"), using 2342\n", td_out_dest_port_str );
    port = 2342;
  }
  if( port < 1 || port > 65535 )
  {
    printf( "config: output: invalid destination port number (%d), using 2342\n", port );
    port = 2342;
  }
  td_out_dest_port = (in_port_t)port;

  //convert device count into number
  if( sscanf( td_out_dev_cnt_str, "%hi", &td_out_dev_cnt ) != 1 )
  {
    printf( "config: output: error in format of device count (\"%s\"), using 32\n", td_out_dev_cnt_str );
    td_out_dev_cnt = 32;
  }
  if( td_out_dev_cnt <= 0 || td_out_dev_cnt > 64 )
  {
    printf( "config: output: invalid device count (%d), using 32\n", td_out_dev_cnt );
    td_out_dev_cnt = 32;
  }

  //convert serial port count into number
  if( sscanf( td_out_ser_cnt_str, "%hi", &td_out_ser_cnt ) != 1 )
  {
    printf( "config: output: error in format of serial port count (\"%s\"), using 32\n", td_out_ser_cnt_str );
    td_out_ser_cnt = 32;
  }
  if( td_out_ser_cnt <= 0 || td_out_ser_cnt > 64 )
  {
    printf( "config: output: invalid serial port count (%d), using 32\n", td_out_ser_cnt );
    td_out_ser_cnt = 32;
  }

  //convert pixel count into number
  if( sscanf( td_out_pix_cnt_str, "%hi", &td_out_pix_cnt ) != 1 )
  {
    printf( "config: output: error in format of pixel count (\"%s\"), using 32\n", td_out_pix_cnt_str );
    td_out_pix_cnt = 32;
  }
  if( td_out_pix_cnt <= 0 || td_out_pix_cnt > 64 )
  {
    printf( "config: output: invalid pixel count (%d), using 32\n", td_out_pix_cnt );
    td_out_pix_cnt = 32;
  }

  //format

  //no format file
  if( td_fmt_file[0] == 0 )
  {
    printf( "config: format: no format file, using \"troia_dist.td_fmt\"\n" );
    strcpy( td_fmt_file, "troia_dist.td_fmt" );
  }
}
