/* TROIA distributor
 * version 0.3 date 2004-09-01
 * Copyright (C) 2003-2004 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_td_fmt
#define INC_td_fmt

//structure for a pixel in a format
typedef struct s_td_fmt_pix
{
  unsigned short dev_no; //number of the device the pixel is connected to
  unsigned short ser_no; //number of the serial port the pixel is connected to
  unsigned short pix_no; //number of the pixel at the serial port
  unsigned int out_buf_ofs; //offset into output buffer (pix_no * ser_cnt + ser_no)
  //all 4 numbers are set to -1 if pixel has to be ignored
  unsigned char sync_bit; //contains 0x80 if pix_no == 0, 0x00 otherwise
  unsigned char valid; //!= 0 if pixel is valid, == 0 if pixel has to be ignored
} st_td_fmt_pix;

//structure for a format
typedef struct s_td_fmt
{
  unsigned short width; //width of the format
  unsigned short height; //height of the format
  st_td_fmt_pix * * pixels; //malloc-ed two-dimensional array with pixels (pixels[<width>][<height>])
} st_td_fmt;

//load a format file
//returns pointer to malloc-ed st_td_fmt structure on success, NULL on error
st_td_fmt * td_fmt_load( char * filename );

//free a format
void td_fmt_free( st_td_fmt * p_td_fmt );

#endif //#ifndef INC_td_config
