/* TROIA distributor
 * version 0.4 date 2005-01-26
 * Copyright (C) 2003-2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#include <stdio.h>
#include <malloc.h>

#include "td_config.h"
#include "td_fmt.h"

//load a format file
//returns pointer to malloc-ed st_td_fmt structure on success, NULL on error
st_td_fmt * td_fmt_load( char * filename )
{
  FILE * p_file;
  st_td_fmt * p_td_fmt;
  int cnt, newline;
  unsigned short x, y;
  char buffer[16];

  //check filename (fopen segaults in these cases)
  if( filename == NULL || filename[0] == 0 )
  {
    printf( "td_fmt: no format file was supplied\n" );
    return NULL;
  }

  //open file
  p_file = fopen( filename, "rt" );
  if( p_file == NULL )
  {
    printf( "td_fmt: could not open format file \"%s\"\n", filename );
    return NULL;
  }

  //allocate structure
  p_td_fmt = (st_td_fmt *)malloc( sizeof( st_td_fmt ) );
  if( p_td_fmt == NULL )
  {
    fclose( p_file );
    printf( "td_fmt: could not allocate format structure\n" );
    return NULL;
  }

  //read width and height
  fscanf( p_file, "%*[ \t\r]" );
  cnt = fscanf( p_file, "%hu%*[ \t\r]%hu", &p_td_fmt->width, &p_td_fmt->height );
  fscanf( p_file, "%*[ \t\r]" );
  newline = fgetc( p_file ) == '\n';
  if( cnt != 2 || ! newline )
  {
    free( p_td_fmt );
    fclose( p_file );
    printf( "td_fmt: could not read dimensions (\"<width> <height>\")\n" );
    return NULL;
  }
  if( p_td_fmt->width < 1 || p_td_fmt->width > 1000 || p_td_fmt->height < 1 || p_td_fmt->height > 1000 )
  {
    free( p_td_fmt );
    fclose( p_file );
    printf( "td_fmt: invalid dimensions (\"%d %d\")\n", p_td_fmt->width, p_td_fmt->height );
    return NULL;
  }

  //allocate two-dimensional array for format pixels
  p_td_fmt->pixels = (st_td_fmt_pix * *)malloc( p_td_fmt->height * sizeof( st_td_fmt_pix * ) );
  if( p_td_fmt->pixels == NULL )
  {
    free( p_td_fmt );
    fclose( p_file );
    printf( "td_fmt: could not allocate pixel buffer for format structure\n" );
    return NULL;
  }
  for( y = 0; y < p_td_fmt->height; y++ )
  {
    p_td_fmt->pixels[y] = (st_td_fmt_pix *)malloc( p_td_fmt->width * sizeof( st_td_fmt_pix ) );
    if( p_td_fmt->pixels[y] == NULL )
    {
      for( y-- ; (short)y >= 0; y-- )
        free( p_td_fmt->pixels[y] );
      free( p_td_fmt->pixels );
      free( p_td_fmt );
      fclose( p_file );
      printf( "td_fmt: could not allocate pixel buffer for format structure\n" );
      return NULL;
    }
  }

  //read format pixels
  for( y = 0; y < p_td_fmt->height; y++ )
  {
    for( x = 0; x < p_td_fmt->width; x++ )
    {
      //read in whitespace
      cnt = fscanf( p_file, "%1[ \t\r]%*[ \t\r]", buffer );
      if( x > 0 && cnt != 1 ) //there must be whitespace if not in the first column
      {
        printf( "td_fmt: missing whitespace before pixel in column %d of row %d\n", x, y );
        break;
      }
      //pixel is invalid by default
      p_td_fmt->pixels[y][x].valid = 0;
      //check if ignore pixel
      cnt = fscanf( p_file, "%1[.,/-]", buffer );
      //it is an ignore pixel
      if( cnt == 1 )
      {
        //mark pixel as invalid
        p_td_fmt->pixels[y][x].dev_no = -1;
        p_td_fmt->pixels[y][x].ser_no = -1;
        p_td_fmt->pixels[y][x].pix_no = -1;
        p_td_fmt->pixels[y][x].out_buf_ofs = -1;
        p_td_fmt->pixels[y][x].sync_bit = 0x80;
        p_td_fmt->pixels[y][x].valid = 0;
      }
      //it is not an ignore pixel
      else
      {
        //read pixel
        cnt = fscanf( p_file,
                      "%hu%*[.,/-]%hu%*[.,/-]%hu",
                      &p_td_fmt->pixels[y][x].dev_no,
                      &p_td_fmt->pixels[y][x].ser_no,
                      &p_td_fmt->pixels[y][x].pix_no );
        //success
        if( cnt == 3 )
        {
          //check values
          if( p_td_fmt->pixels[y][x].dev_no >= td_out_dev_cnt
           || p_td_fmt->pixels[y][x].ser_no >= td_out_ser_cnt
           || p_td_fmt->pixels[y][x].pix_no >= td_out_pix_cnt )
          {
            printf( "td_fmt: pixel in column %d of row %d (\"%d-%d-%d\") does not exist\n",
                    x, y,
                    p_td_fmt->pixels[y][x].dev_no,
                    p_td_fmt->pixels[y][x].ser_no,
                    p_td_fmt->pixels[y][x].pix_no );
            break;
          }
          //calculate offset into output buffer
          p_td_fmt->pixels[y][x].out_buf_ofs = p_td_fmt->pixels[y][x].pix_no * td_out_ser_cnt
                                             + p_td_fmt->pixels[y][x].ser_no;
          //save sync bit
          p_td_fmt->pixels[y][x].sync_bit = p_td_fmt->pixels[y][x].pix_no == 0 ? 0x80 : 0x00;
          //mark pixel as valid
          p_td_fmt->pixels[y][x].valid = 1;
        }
        else
        {
          printf( "td_fmt: pixel in column %d of row %d has invalid format\n", x, y );
          break;
        }
      } //it is not an ignore pixel
    } //for( x ...
    //end outer loop if error during inner loop
    if( x < p_td_fmt->width )
      break;
    //read newline
    fscanf( p_file, "%*[ \t\r]" );
    newline = fgetc( p_file ) == '\n';
    if( ! newline )
    {
      if( ! feof( p_file ) )
        printf( "td_fmt: too much pixels specified for row %d\n", y );
      else
        printf( "td_fmt: too few rows specified\n" );
      break;
    }
  } //for( y ...
  //error found during loop
  if( y < p_td_fmt->height )
  {
    for( y = 0; y < p_td_fmt->height; y++ )
      free( p_td_fmt->pixels[y] );
    free( p_td_fmt->pixels );
    free( p_td_fmt );
    return NULL;
  }

  //close file
  fclose( p_file );

  return p_td_fmt;
}

//free a format
void td_fmt_free( st_td_fmt * p_td_fmt )
{
  unsigned short y;

  //free two-dimensional array with format pixels
  for( y = 0; y < p_td_fmt->height; y++ )
    free( p_td_fmt->pixels[y] );
  free( p_td_fmt->pixels );

  //free structure
  free( p_td_fmt );
}
